function flip = findFA(T1, T2, TR, Ro, J)
% cakculate flip angle such that the ratio between A0 and AJ is Ro.
FA = linspace(0, 90, 1000);
E1 = exp(-TR/T1); E2 = exp(-TR/T2);
% a = -(1 - E1)*E2*sind(FA);
% b = (1 - E1)*sind(FA);
c = E2*(E1 - 1)*(1 + cosd(FA));
d = 1 - E1*cosd(FA) - (E1 - cosd(FA))*E2^2;
m = -c./d;
E = (1 - sqrt(1 - m.^2))./m;
logR = -J*log(E);
if J > 0
    flip = interp1(logR, FA, log(Ro));
else
    flip = 45;
end
